//
//  ManojPDFView.m
//  Radaeepdf Demo App
//
//  Created by Manoj Aher on 8/5/15.
//  Copyright (c) 2015 manojaher. All rights reserved.
//

#import "ManojPDFView.h"
#import <QuartzCore/QuartzCore.h>

@implementation ManojPDFView

extern int g_def_view;
extern float g_Ink_Width;
extern float g_rect_Width;
extern uint g_ink_color;
extern uint g_rect_color;
extern uint g_oval_color;
extern bool g_paging_enabled;

#pragma mark - Overridden methods

-(void)vOpen:(PDFDoc *)doc :(id<PDFViewDelegate>)delegate
{
    //GEAR
    [self vClose];
    //END
    m_doc = doc;
    bool *verts = (bool *)calloc( sizeof(bool), [doc pageCount] );
    switch(g_def_view)
    {
        case 1:
            m_view = [[PDFVHorz alloc] init:false];
            break;
        case 2:
            m_view = [[PDFVHorz alloc] init:true];
            break;
        case 3:
            //for dual view, comment/uncomment also doublePage
            //            m_view = [[PDFVDual alloc] init:false :NULL :0 :NULL :0];
            //            doublePage = YES;
            //for single view , comment/uncomment also doublePage
            m_view = [[PDFVDual alloc] init:false :NULL :0 :verts :doc.pageCount];
            doublePage = NO;
            break;
        case 4:
            //for dual view, comment/uncomment also doublePage
            m_view = [[PDFVDual alloc] init:true :NULL :0 :NULL :0];
            doublePage = YES;
            //for single view, comment/uncomment also doublePage
            //m_view = [[PDFVDual alloc] init:true :NULL :0 :verts :doc.pageCount];
            //doublePage = NO;
            break;
        default:
            m_view = [[PDFVVert alloc] init];
            break;
    }
    
    free( verts );
    m_delegate = delegate;
    [self setupPDFView];    
}

-(void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSSet *allTouches = [event allTouches];
    int cnt = [allTouches count];
    if( cnt == 1 )
    {
        UITouch *touch = [[allTouches allObjects] objectAtIndex:0];
        CGPoint point=[touch locationInView:[touch view]];
        point.x *= m_zoom;
        point.y *= m_zoom;
        [self OnNoneTouchBegin:point:touch.timestamp];
    }
}

-(void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSSet *allTouches = [event allTouches];
    int cnt = [allTouches count];
    
    if( cnt == 1 )
    {
        UITouch *touch = [[allTouches allObjects] objectAtIndex:0];
        CGPoint point=[touch locationInView:[touch view]];
        point.x *= m_zoom;
        point.y *= m_zoom;
        [self OnNoneTouchMove:point:touch.timestamp];
    }
}

-(void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event
{
    UITouch *touch = [touches anyObject];
    if (touch.tapCount == 2 && m_status == sta_none) {
        //this is the double tap action
        [self OnDoubleTap:touch];
    }
    else
    {
        NSSet *allTouches = [event allTouches];
        int cnt = [allTouches count];
        if( cnt == 1 )
        {
            UITouch *touch = [[allTouches allObjects] objectAtIndex:0];
            CGPoint point=[touch locationInView:[touch view]];
            point.x *= m_zoom;
            point.y *= m_zoom;
            [self OnNoneTouchEnd:point:touch.timestamp];
        }
    }
}

-(void)onSingleTap:(float)x :(float)y
{
    [m_view vGetPos:&m_annot_pos :x * m_scale :y * m_scale];
    if( m_annot_pos.pageno >= 0 )
    {
        PDFVPage *vpage = [m_view vGetPage:m_annot_pos.pageno];
        if( !vpage )//shall not happen
        {
            if([m_delegate respondsToSelector:@selector(OnSingleTapped::)])
                [m_delegate OnSingleTapped:x:y];
            return;
       	}
        PDFPage *page = [vpage GetPage];
        if( !page ) return;
        m_annot = [page annotAtPoint:m_annot_pos.x: m_annot_pos.y];
        if( m_annot )
        {
            [self refresh];
            if( [m_delegate respondsToSelector:@selector(OnAnnotClicked::::)])
            {
                [m_delegate OnAnnotClicked :page:m_annot:x:y];
            }
        }
        else
        {
            if( [m_delegate respondsToSelector:@selector(OnSingleTapped::)])
            {
                [self performBlock:^{
                    if (!isDoubleTapping) {
                        [m_delegate OnSingleTapped:x:y];
                    }
                } afterDelay:0.3];
            }
        }
    }
}


-(void)OnPageChanged:(int)pageno
{
    if([m_delegate respondsToSelector:@selector(OnPageChanged:)])
        [m_delegate OnPageChanged:pageno];
}

-(void)OnNoneTouchMove:(CGPoint)point :(NSTimeInterval)timeStamp
{
    NSTimeInterval del = timeStamp - m_tstamp;
    if( del > 0 )
    {
        float dx = point.x * m_scale - m_px;
        float dy = point.y * m_scale - m_py;
        float vx = dx/del;
        float vy = dy/del;
        dx = 0;
        dy = 0;
        if( vx > 50 || vx < -50 )
            dx = vx;
        if( vy > 50 || vy < -50 )
            dy = vy;
        else if( timeStamp - m_tstamp_tap > 1 )//long pressed
        {
            dx = point.x * m_scale - m_tx;
            dy = point.y * m_scale - m_ty;
            if( dx < 10 && dx > -10 && dy < 10 && dy > -10 )
            {
                m_status = sta_none;
                if([m_delegate respondsToSelector:@selector(OnLongPressed::)])
                    [m_delegate OnLongPressed:point.x :point.y];
            }
        }
    }
    m_px = point.x * m_scale;
    m_py = point.y * m_scale;
}

-(bool)OnSelTouchBegin:(CGPoint)point
{
    if( m_status != sta_sel )
    {
        return false;
    }
    m_tx = point.x * m_scale;
    m_ty = point.y * m_scale;
    if( [m_delegate respondsToSelector:@selector(OnSelStart::)])
    {
        [m_delegate OnSelStart:point.x: point.y];
    }
    return true;
}

-(bool)OnSelTouchEnd:(CGPoint)point
{
    if( m_status != sta_sel ) return false;
    [m_view vSetSel:m_tx: m_ty: point.x * m_scale: point.y * m_scale];
    [self refresh];
    if([m_delegate respondsToSelector:@selector(OnSelEnd::::)])
    {
        [m_delegate OnSelEnd :m_tx/m_scale: m_ty/m_scale:point.x :point.y];
    }
    return true;
}

-(void)OnFound:(PDFVFinder *)finder
{
    [m_view vFindGoto];
    CGPoint pt;
    pt.x = [m_view vGetX]/m_scale;
    pt.y = [m_view vGetY]/m_scale;
    self.contentOffset = pt;
    
    if([m_delegate respondsToSelector:@selector(OnFound:)])
    {
        int pageno = [finder find_get_page];
        [m_delegate OnFound: (pageno >= 0 && pageno < [m_doc pageCount])];
    }
    
    if ([finder find_get_page] >= 0 && [finder find_get_page] < m_doc.pageCount)
    {
        [self vGoto:[finder find_get_page]];
    }
}

-(void)vFind:(int)dir
{
    if( [m_view vFind:dir] < 0 && [m_delegate respondsToSelector:@selector(OnFound:)])
    {
        [m_delegate OnFound:false];
    }
    [self refresh];
}


- (void)OnDoubleTap:(UITouch *)touch
{
    isDoubleTapping = YES;
    
    NSLog(@"double tap");
    if (m_zoom > 1)
    {
        self.pagingEnabled = YES;
        [self resetZoomLevel];
    }
    else
    {
        self.pagingEnabled = NO;
        [self initZoomWithPoint:[touch locationInView:self.window]];
        [self zoomToScale:2.0 atPoint:[touch locationInView:self.window]];
    }
    
    if ([m_delegate respondsToSelector:@selector(OnDoubleTapped::)])
    {
        [m_delegate OnDoubleTapped:[touch locationInView:self.window].x :[touch locationInView:self.window].y];
    }
    
    [self performBlock:^{
        isDoubleTapping = NO;
    } afterDelay:0.5];
}

-(void)vAnnotEnd
{
    if( m_status != sta_annot ) return;
    m_status = sta_none;
    self.scrollEnabled = true;
    m_annot = NULL;
    [self refresh];
    if([m_delegate respondsToSelector:@selector(OnAnnotEnd)])
    {
        [m_delegate OnAnnotEnd];
    }
}

-(void)vAnnotPerform
{
    if( m_status != sta_annot ) return;
    int pageno = [m_annot getDest];
    if( pageno >= 0 )//goto page
    {
        if( [m_delegate respondsToSelector:@selector(OnAnnotGoto:)])
        {
            [m_delegate OnAnnotGoto:pageno];
        }
        [self vAnnotEnd];
        return;
    }
    NSString *nuri = [m_annot getURI];
    if(nuri)//open url
    {
        if( [m_delegate respondsToSelector:@selector(OnAnnotOpenURL:)])
        {
            [m_delegate OnAnnotOpenURL:nuri];
        }
        [self vAnnotEnd];
        return;
    }
    nuri = [m_annot getMovie];
    if( nuri )
    {
        nuri = [[NSTemporaryDirectory() stringByAppendingString:@"/"] stringByAppendingString:nuri];
        [m_annot getMovieData:nuri];
        if([m_delegate respondsToSelector:@selector(OnAnnotMovie:)])
        {
            [m_delegate OnAnnotMovie:nuri];
        }
        [self vAnnotEnd];
        return;
    }
    nuri = [m_annot getSound];
    if( nuri )
    {
        int spara[4];
        nuri = [[NSTemporaryDirectory() stringByAppendingString:@"/"] stringByAppendingString:nuri];
        [m_annot getSoundData:spara :nuri];
        if([m_delegate respondsToSelector:@selector(OnAnnotSound:)])
        {
            [m_delegate OnAnnotSound:nuri];
        }
        [self vAnnotEnd];
        return;
    }
    nuri = [m_annot getPopupText];
    if( nuri )
    {
        //popup dialog to show text and subject.
        //nuri is text content.
        //subj is subject string.
        if( [m_delegate respondsToSelector:@selector(OnAnnotPopup:::)])
        {
            [m_delegate OnAnnotPopup :m_annot: [m_annot getPopupSubject] :nuri];
        }
        [self vAnnotEnd];
        return;
    }
    [self vAnnotEnd];
    return;
}


@end
